/*---------------------------------------------------------------------------*\

    FILE....: MESS.CPP
    TYPE....: C Function File
    AUTHOR..: John Kostogiannis
    DATE....: 20/11/97

    Interface functions for messages.  Messages are information sent by
    various modules to a message window just like printf to the console. 

    Used for driver debugging.
	
    DR 12/9/99:
    Removed all Windows stuff for Linux port.  These functions were used
    mainly for console-mode debug anyway.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "mess.h"
#include "wobbly.h"
#include "generic.h"

/*-------------------------------------------------------------------------*\

				DEFINES

\*-------------------------------------------------------------------------*/

#define MAXLINESOFMESS	100

/*-------------------------------------------------------------------------*\

				STATICS

\*-------------------------------------------------------------------------*/

static int enable;
static int file_enable;

static char file_name[VPB_MAX_STR];
static GENERIC_CRITICAL_SECTION	MessSect;

/*-------------------------------------------------------------------------*\

			       FUNCTIONS

\*-------------------------------------------------------------------------*/

void mess_init() {
	//		GenericInitializeCriticalSection(&MessSect);
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This version was used for Win32 but isnt used any more (I think).

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(int h,int hInt){
	assert(0);
	enable = OFF;
	file_enable = OFF;
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Enables mprintf statements.  Either this function of mprintf_off should
    be called during program initialisation to place the mprintf functions
    in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(void){
	enable = ON;
	file_enable = OFF;
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_on
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This version send mprintf messages to a text file, rather than the
    console.

\*-------------------------------------------------------------------------*/

void mess_mprintf_on(char *fn){
	FILE *f;
	
	enable = ON;
	file_enable = ON;
	strcpy(file_name, fn);
	f = fopen(file_name,"wt");
	assert(f != NULL);
	fclose(f);
}

/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf_off
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Disables mprintf statements.  Either this function or mprintf_on should
    be called during program initialisation to place the mprintf functions
    in a known state.

\*-------------------------------------------------------------------------*/

void mess_mprintf_off(void)
{
	enable = OFF;
	if(file_enable == ON){
		file_enable = OFF;
	}
}
	
/*-------------------------------------------------------------------------*\

    FUNCTION.: mprintf
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    Similar to printf, but send messages to console, file, or just does
    nothing when mprintf is disabled.

\*-------------------------------------------------------------------------*/

void mprintf(char *fmt, ...)
{
	va_list argptr;
	int     ret;
	FILE    *f;

	//GenericEnterCriticalSection(&MessSect);

	if(enable) {
		va_start(argptr, fmt);
		if(file_enable) {
			f = fopen(file_name, "at");
			ret = vfprintf(f,fmt,argptr);
			fclose(f);
			assert(ret != 0);
		}
		else {
			vprintf(fmt, argptr);
		}

		va_end(argptr);
	}

	//GenericLeaveCriticalSection(&MessSect);
}

